#version 330
#extension GL_EXT_gpu_shader4 : enable
// Divine SpiderMod01.fsh by  anclin

//https://www.shadertoy.com/view/wl2Gzt
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


float SinLerp(float min, float max, float t) {
 	return mix(min, max, sin(t) * 0.5 + 0.5);   
}

float Sin01(float t) {
 	return SinLerp(0., 1., t);
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = (gl_FragCoord.xy-.5*iResolution.xy)/iResolution.y;
    
    // Time varying pixel color
    vec3 col = vec3(uv,0);
    
    float t = iTime * .3;
    
    // polar
    vec2 st = vec2(atan(uv.x, uv.y), length(uv));
    st.x = st.x/6.28+0.5;
	col = vec3(st.x);
    
    
    //st.x += st.y * SinLerp(0., 2., iTime);
    uv = st;
    
    
    
    // zig zag
    float p = 1.; // petals
    float x = uv.x * p;// + t * 0.5;
    float y = uv.y * SinLerp(.2, 1., t);
    
    // RINGS
    float r = y + sin( uv.y * 7. * SinLerp(1., 2., t) - t*3.5);
    // FLOWER
    float z = min(fract(x), fract(1.-x)); 
    
    
    col = vec3(z);
    col = vec3(r + z);
    float s = 20.;//SinLerp(4., 15., t); // split of the petal
    //col = vec3(r + fract( z * s) );
    col = vec3(fract(r + fract( z * s) ));
    
    // Output to screen
    gl_FragColor = vec4(col, 1.);
}